	output d:\assemble\sources.v45\wax_gifv\wax_gifv.acx

OPT_GWVA_DEBUG_ERROR			; [option][root] generates an illegal when something goes wrong (for debugging purposes)
OPT_GWVA_DEBUG_PRINT_COMMENTS		; [option][root] print comments/warnings when assembling source

*OPT_GWVA_DEBUG_SEARCH_EXEC		; [option][root] is needed to do any log alert_box/logger
*OPT_GWVA_DEBUG_FILTER	 		; [var] filters debug messages to those in the list defined by OPT_GWVA_DEBUG_FILTER_PTR
*OPT_GWVA_DEBUG_FILTER_PTR		; [var] pointer to the list of the GWVA_OBJ_NAME of objects to debug (end with 0.l)
*OPT_GWVA_DEBUG_FILTER_0NAMES	 	; [option][root][OPT_GWVA_DEBUG_SEARCH_EXEC] filters debug messages for all objets having a 0.L in GWVA_OBJ_NAME
*OPT_GWVA_DEBUG_SEARCH_EXEC_IN_ALERT_BOX	; [option][root][LIB_HEXA][LIB_DECI][OPT_GWVA_DEBUG_SEARCH_EXEC] prints an alert box at each method distribution
*OPT_GWVA_DEBUG_SEARCH_EXEC_IN_LOGGER	; [option][root][LIB_HEXA][LIB_DECI][OPT_GWVA_DEBUG_SEARCH_EXEC][GWVA_DEBUG_MSG_MAX_SIZE][GWVA_DEBUG_MAX_MSG_DEBUG_PENDING] prints in log window each method distribution
*GWVA_DEBUG_MSG_MAX_SIZE = 256		; [var] defines the debug message max length (generated by SEARCH_EXEC)
*GWVA_DEBUG_MAX_MSG_DEBUG_PENDING = 64	; [var] how many debug messages can be sent in a row

*LIB_HEXA				; [root]
*LIB_DECI				; [root]

OPT_FULL_PATHNAMES

	lea objet_application,a1

	include wax_gifv.def
	include visual45.s
	include wax_gifv.hs
	include wax_gifv.obj

	comment HEAD=7
	section TEXT

*--------------------------------------------------------------------------*

	; ce programme rpond aux quatre lois de l'ouverture :
	; 1) ligne de commande
	; 2) si pas de ligne de commande : slecteur de fichiers
	;    et si annule, CTRL+O -> redemande
	; 3) en accessoire : un click appelle le slecteur
	; 4) en accessoire, supporte le VA_START

*--------------------------------------------------------------------------*

my_inits_created:
	tst GWVA_ROOT_IS_ACC_PRG
	beq.s .acc

	bfset objet_application+GWVA_WIND_OBJ_PROPERTIES{GWVA_WIND_OLBIT_AMENU:1}	; menu

.acc:	moveq #GWVA_PRGRET_CONSUMED,d6
	rts
			**********
my_inits_opened:
	tst GWVA_ROOT_IS_ACC_PRG
	beq.s .acc

	tst.w d0
	beq.s acc_open	; pour ouvrir un slecteur

	move.l a1,a0
	bra.s open_object

.acc:	moveq #GWVA_PRGRET_CONSUMED,d6	; rien si ACC
	rts
			**********
acc_open:
menu_open:
	lea texte_gif,a0		; 35 chars max.
	lea mask_gif,a1		; 18 caracteres max
	move.l #0,a2
	bsr GWVA_FILE_SELECTOR
	tst d0
	ble .annule

	move.l a2,a0
	bra.s open_object

.annule:	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

open_wind_info:
	lea objet_fenetre_info,a0
	bsr GWVA_WIND_CREATE_OPEN_ONE_WIND

	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

routine_menu_quit:
app_term:
acc_close:
	; quoi qu'il arrive, il y a 1 delete all wind

	bsr GWVA_ROOT_KILL_APPLICATION

	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

*--------------------------------------------------------------------------*

; Sur un event_message (VA_START) on appelle la mthode si elle est prsente avec
; le buffer GEM en entre point par a1, a0 pointeur sur l'objet application, 
; le numro du message dans d0.w.

va_start_message:
	GWVA_CALL_METHOD_OTHER_OBJ	#GWVA_METHOD_OPEN

	move.l bmsg_start_free_data(a1),a0

	cmp.w #GWVA_NO_ERROR_GENERIC,d7
	beq.s open_object

	; ne pas partir boucle infinie : et si jamais 1 vstation se libre ?

	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

*--------------------------------------------------------------------------*

open_object:		; ici : a0 pointeur sur un pathname !

	include depack.s

	bsr put_in_screen_format

	MFREE gif_img
	clr.l gif_img

	tst d7
	bge.s .ok

	MFREE gif_for_screen
	clr.l gif_for_screen
	graf_mouse #ARROW

	moveq #GWVA_PRGRET_CONSUMED,d6
	rts
.ok:

	*---------

	; on fait un malloc de la taille d'une structure de fentre
	; bitmap, on reloge et on recopie tout comme il faut dedans

	lea objet_fenetre_clone,a0
	lea offsets_objet_fenetre_clone,a1
	move.l #fin_objet_fenetre_clone-objet_fenetre_clone,d0	; les 2 ont la mme taille
	move.w #GWVA_ROOT_CTE_CLONE_RELOC_ONE_OBJECT,d1
	bsr GWVA_ROOT_CLONE_OBJECT
	cmp.w #GWVA_NO_ERROR_GENERIC,d7
	bne .erreur_clone		; plus de mmoire

	move.l a0,GWVA_WIND_OBJ_USER_PTR1(a0)
	; sera libr automatiquement car on a mis le bit GWVA_WIND_OLBIT_FREEPTR1 des PROPERTIES

	move gif_loaded_width,GWVA_WIND_OBJ_FIRST_INT_VISIBLE_W(a0)
	move gif_loaded_height,GWVA_WIND_OBJ_FIRST_INT_VISIBLE_H(a0)
	move gif_loaded_width,GWVA_WBITM_OBJ_IMG_WIDTH(a0)
	move gif_loaded_height,GWVA_WBITM_OBJ_IMG_HEIGHT(a0)
	move.l gif_for_screen,GWVA_WBITM_OBJ_DATA_PTR(a0)
	move.l gif_palette,GWVA_WBITM_OBJ_PAL_PTR(a0)
	move.w #8,GWVA_WBITM_OBJ_NB_BITPLANES(a0)

	move.l ptr_pathname,a2
	move.l GWVA_WIND_OBJ_INFO_PTR(a0),a3
	COPY_STRING_0 a2,a3

	bsr GWVA_WIND_CREATE_OPEN_ONE_WIND

	cmp.w #GWVA_NO_ERROR_GENERIC,d7
	beq.s .opened_ok

	; si la cration choue ... la mmoire a t libre
	; soit : DATA_PTR, PAL_PTR et USR_PTR1

	move #ALERT_NO_MORE_WI,d0
	move #1,d1
	bsr GWVA_RSC_ALERT_BOX

.opened_ok:
.no:
	graf_mouse #ARROW
	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

.erreur_clone:
	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

*--------------------------------------------------------------------------*

	include routines.s

*--------------------------------------------------------------------------*

erreur_load:graf_mouse #ARROW
	move #ALERT_FILE_NOTF,d0
	move #1,d1
	bsr GWVA_RSC_ALERT_BOX
	bra.s rends_mem

err_malloc:	graf_mouse #ARROW
	move #ALERT_NOT_ENOUGH,d0
	move #1,d1
	bsr GWVA_RSC_ALERT_BOX

rends_mem:	MFREE gif_loaded_address
	clr.l gif_loaded_address

	MFREE strings
	clr.l strings

	MFREE gif_buff
	clr.l gif_buff

	MFREE gif_img
	clr.l gif_img

	MFREE gif_for_screen
	clr.l gif_for_screen

	MFREE gif_palette
	clr.l gif_palette

	rts

err_not_gif:
err_not_256_coul:
err_interlaced:
err_not_8_bits:
	graf_mouse #ARROW

	move #ALERT_NOT_GOOD_F,d0
	move #1,d1
	bsr GWVA_RSC_ALERT_BOX

	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

*--------------------------------------------------------------------------*
menu_save_palette:

	bsr GWVA_WIND_RETURN_TOP_WINDOW
	cmp #GWVA_NO_ERROR_GENERIC,d7
	bne .the_top_windows_is_not_mine

	cmp.w #GWVA_CLASS_WIND.BITMAP,GWVA_OBJ_CLASS(a0)
	bne.s .pas_bitmap

	save.l a0
	lea texte_pal,a0		; 35 chars max.
	lea mask_pal,a1		; 18 caracteres max
	move.l #0,a2
	bsr GWVA_FILE_SELECTOR
	load.l a0
	tst d0
	ble .annule

	save.l a0
	FILE_OPEN write,(a2),d7
	load.l a0
	tst d7
	bmi.s .bad_handle

	FWRITE <GWVA_WBITM_OBJ_PAL_PTR(a0)>,#4*256,d7

	FCLOSE d7

.bad_handle:
.annule:
.pas_bitmap:
.the_top_windows_is_not_mine:
	moveq #GWVA_PRGRET_CONSUMED,d6
	rts
*--------------------------------------------------------------------------*

	section DATA

texte_gif:	dc.b 'Locate file to view : ',0
texte_pal:	dc.b 'File to save palette : ',0
mask_gif:	dc.b '*.GIF',0
mask_pal:	dc.b '*.PAL',0

*--------------------------------------------------------------------------*

	section BSS

gif_loaded_address:	ds.l 1
gif_loaded_length:	ds.l 1
gif_loaded_width:	ds.w 1
gif_loaded_width_rounded_16:ds.w 1
gif_loaded_height:	ds.w 1
gif_loaded_nb_colors:	ds.w 1
gif_loaded_nb_planes:	ds.w 1

gif_palette:	ds.l 1

	; pour le dcompactage

string_table:	ds.l 2*4096		; maximum 12 bits

current_max_code:	ds.w 1

ptr_strings:	ds.l 1

ptr_table:		ds.l 1

strings:		ds.l 1
; ds.b 640*480+4096	; mmoire dynamique ... 12 bits
; au pire : 256*1 + 2 + 3 + ... + (4096-256) = 256 + 3840*3841/2-1=7374975
; au max une image vide 640*480  1 ... 784 en incrment de 1

gif_buff:		ds.l 1
;	ds.b 640*480	taille si packing nul : pour suret
;			buff remise  l'endroit code compact
fin_gif_buff:	ds.l 1

gif_img:		ds.l 1
; ds.b 640*480	; l sera dcompacte l'image
; ds.b 639+1024	; 639 : erreur Prism Paint

gif_for_screen:	ds.l 1
ptr_pathname:	ds.l 1
 END
